---
name: data-insights
description: |
  Use when the user provides CSV data, a spreadsheet, or tabular data and wants
  analysis, visualizations, or an interactive dashboard. Triggers on requests like
  "analyze this data", "create a dashboard", "show me trends", "visualize this CSV",
  "give me insights from this spreadsheet", or "build a report from this data".
  Also triggers when the user uploads a .csv file and asks for any kind of analysis.
---

# Data Insights

Transform raw tabular data into interactive HTML dashboards with charts, summaries, and actionable insights.

## What This Skill Does

Given any CSV or tabular data, this skill:
1. Analyzes the data structure (columns, types, distributions)
2. Computes summary statistics and identifies trends
3. Generates an interactive HTML dashboard with Chart.js visualizations
4. Provides written insights and recommendations
5. Optionally exports detailed findings to Excel (using the xlsx skill)

## Instructions

### Step 1: Assess the Data

Read the user's CSV data or uploaded file. Identify:
- **Numeric columns** (revenue, counts, scores) — candidates for charts and stats
- **Categorical columns** (regions, products, categories) — candidates for grouping
- **Date/time columns** (months, quarters, dates) — candidates for trend analysis
- **Data quality issues** (missing values, outliers, inconsistencies)

If the data is messy, clean it first using the script in `scripts/clean_data.py`.

### Step 2: Generate Summary Statistics

For each numeric column, compute:
- Total, mean, median, min, max
- Standard deviation
- Month-over-month or period-over-period change (if a time column exists)
- Top/bottom performers (if a categorical grouping exists)

### Step 3: Build the Dashboard

Use the HTML template in `templates/dashboard-template.html` as a starting point.

**Required dashboard sections:**
1. **KPI Cards** — 3-5 large stat callouts at the top (total revenue, avg satisfaction, growth %, etc.)
2. **Trend Chart** — Line or bar chart showing the primary metric over time
3. **Breakdown Chart** — Grouped bar or pie chart showing performance by category
4. **Comparison Table** — Sortable HTML table with key metrics by segment
5. **Insights Panel** — 3-5 bullet points with data-driven observations

**Chart library:** Use Chart.js (loaded from CDN in the template).

**Color palette:** Use the palette defined in `assets/color-palette.json`.

### Step 4: Write Insights

Generate 3-5 actionable insights based on the data. Each insight should:
- State a specific finding (with numbers)
- Explain why it matters
- Suggest a possible action

Example: "North region Widget Pro revenue grew 27% from Jan to Jun ($51K → $66.7K), outpacing all other segments. Consider allocating additional marketing budget to this high-growth area."

### Step 5: Deliver

Save the dashboard as an HTML file. Offer to:
- Open it in the browser for immediate viewing
- Export detailed data to Excel using the xlsx skill
- Pull in additional data via MCP if connected (e.g., from Google Sheets or a database)

## MCP Integration (Optional)

If MCP connectors are available, this skill can:
- **Google Sheets MCP**: Pull live data directly from a shared spreadsheet
- **Database MCP**: Query SQL databases for fresh data
- **Slack MCP**: Post a summary of key insights to a team channel
- **Email MCP**: Send the dashboard as an attachment to stakeholders

To use MCP, check which connectors are available and adapt the data ingestion step accordingly. The analysis and dashboard generation steps remain the same regardless of data source.

## Sub-Agent Delegation (Advanced)

For very large datasets or complex analyses, delegate subtasks:

1. **Data cleaning sub-agent**: "Clean this CSV data using scripts/clean_data.py. Fix missing values, normalize date formats, and remove duplicates. Return the cleaned CSV."

2. **Statistical analysis sub-agent**: "Compute summary statistics for all numeric columns grouped by [category]. Include period-over-period changes. Return results as JSON."

3. **Dashboard rendering sub-agent**: "Build an HTML dashboard using templates/dashboard-template.html with this data and Chart.js. Include KPI cards, trend charts, and a comparison table."

## Quality Checklist

Before delivering, verify:
- [ ] All charts render correctly with proper labels and legends
- [ ] KPI numbers match the source data (spot-check at least 2)
- [ ] No JavaScript errors in the browser console
- [ ] Dashboard is responsive (works on different screen sizes)
- [ ] Insights reference specific numbers from the data
- [ ] Color palette is consistent across all visual elements
