# Visualization Guide

Reference for choosing the right chart type based on the data and the question being asked.

## Chart Selection Matrix

| Question | Chart Type | When to Use |
|----------|-----------|-------------|
| How does a metric change over time? | Line chart | Time series with continuous data |
| How do categories compare? | Bar chart (vertical) | Comparing 3-10 categories |
| What is the composition? | Pie / Doughnut | Showing parts of a whole (max 6 segments) |
| How are two metrics related? | Scatter plot | Exploring correlation between variables |
| What is the distribution? | Histogram | Understanding data spread |
| How do groups perform over time? | Grouped bar chart | Comparing multiple series over time |
| What is the ranking? | Horizontal bar | Showing ordered comparisons |

## Chart.js Configuration Tips

### Color Palette Usage

Apply colors from `assets/color-palette.json` consistently:
- Use the primary palette for main data series
- Use the muted palette for secondary/background elements
- Never use more than 6 colors in a single chart

### Readability Standards

- Always include axis labels and a clear title
- Use `toLocaleString()` for number formatting in tooltips
- Set minimum font size of 12px for labels
- Include a legend when showing multiple data series
- Use gridlines sparingly (light color, dashed style)

### Responsive Design

All charts must be responsive. Use Chart.js defaults:
```javascript
{
  responsive: true,
  maintainAspectRatio: true,
  plugins: {
    legend: { position: 'bottom', labels: { padding: 20 } }
  }
}
```

## KPI Card Best Practices

- Show 3-5 KPIs maximum (more dilutes impact)
- Lead with the most important metric
- Always include a comparison (vs. previous period, vs. target)
- Use green for positive change, red for negative
- Format large numbers with abbreviations ($1.2M not $1,200,000)

## Insight Writing Guidelines

Each insight should follow this pattern:

1. **Finding**: State a specific, quantified observation
2. **Context**: Explain why this matters or how it compares
3. **Action**: Suggest what to do about it

Example:
> "North region Widget Pro revenue grew 27% from Jan to Jun ($51K to $66.7K), the strongest growth across all segments. Consider increasing inventory allocation and marketing spend in this region to capitalize on the momentum."
